const express = require("express");
const http = require("http");
const { Server } = require("socket.io");
const cors = require("cors");

const app = express();
app.use(cors());

const server = http.createServer(app);
const io = new Server(server, {
  cors: {
    origin: "http://localhost:5173",
    methods: ["GET", "POST"]
  }
});

// Store connected users: socket.id => username
const users = new Map();

io.on("connection", (socket) => {
  console.log("New user connected:", socket.id);

  // Handle setting username
  socket.on("setUsername", (username) => {
    users.set(socket.id, username);
    console.log(`${username} joined. Total users: ${users.size}`);
    emitUsersList(); // Update everyone
  });

  // Handle message sending
  socket.on("sendMessage", (data) => {
    console.log("Message received:", data);
    io.emit("receiveMessage", data); // Broadcast to all
  });

  // Handle setting username
  socket.on("setUsername", (username) => {
    users.set(socket.id, username);
    console.log(`${username} joined. Total users: ${users.size}`);

    // Send user list to everyone
    emitUsersList();

    // Notify others that this user joined (but not to the user themself)
    socket.broadcast.emit("receiveMessage", {
      text: `${username} has joined the chat`,
      type: "system", // custom type
      timestamp: new Date(),
    });
  });

  // Handle user requesting user list manually (e.g., from menu)
  socket.on("getUsersList", () => {
    const usernames = Array.from(users.values());
    socket.emit("usersList", usernames);
  });

  // Handle disconnect
  socket.on("disconnect", () => {
    const username = users.get(socket.id);
    users.delete(socket.id);

    if (username) {
      console.log(`${username} disconnected`);

      // Send "user left" system message to others
      socket.broadcast.emit("receiveMessage", {
        text: `${username} has left the chat`,
        type: "system",
        timestamp: new Date(),
      });

      emitUsersList(); // Update list
    }
  });


  // Utility to emit user list to all clients
  function emitUsersList() {
    const usernames = Array.from(users.values());
    io.emit("usersList", usernames);
  }
});

server.listen(5000, () => {
  console.log("Server running on http://localhost:5000");
});
